/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.dynamicjava;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import cz.insophy.inplan.util.dynamicjava.DynamicJavaUtils;
import cz.insophy.inplan.util.dynamicjava.RootDefinition;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compiler {
    private static final Logger LOG = LoggerFactory.getLogger(Compiler.class);

    public static void compile(@Nonnull Path buildDir, @Nonnull List<RootDefinition> sourceRoots, @Nonnull List<RootDefinition> resourceRoots) throws IOException {
        Multimap<Path, File> files;
        try {
            files = Compiler.getFiles(sourceRoots);
        }
        catch (IOException e) {
            LOG.error("Could not obtain compiled files list.");
            throw new RuntimeException(e);
        }
        if (files.isEmpty()) {
            LOG.warn("No source files in the specified root(s). Skipping compilation and resource copying.");
            return;
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnosticsCollector = new DiagnosticCollector();
        try (StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnosticsCollector, null, StandardCharsets.UTF_8);){
            Compiler.setLocations(buildDir, files, fileManager);
            JavaCompiler.CompilationTask task = Compiler.createCompilationTask(files, compiler, fileManager);
            if (!task.call().booleanValue()) {
                diagnosticsCollector.getDiagnostics().forEach(d -> LOG.error(d.getMessage(null)));
                throw new IllegalStateException("Compilation failed.");
            }
        }
        try {
            Compiler.copyResources(buildDir, resourceRoots);
        }
        catch (IOException e) {
            LOG.error("Problem with copying resources.");
            throw e;
        }
    }

    private static Multimap<Path, File> getFiles(@Nonnull List<RootDefinition> rootsFiles) throws IOException {
        LinkedHashMultimap<Path, File> rootsFilesList = LinkedHashMultimap.create();
        DynamicJavaUtils.walkRoots(rootsFiles, null, file -> rootsFilesList.put(file.root, file.path.toFile()));
        return rootsFilesList;
    }

    private static void setLocations(Path buildDir, Multimap<Path, File> files, StandardJavaFileManager fileManager) throws IOException {
        fileManager.setLocation(StandardLocation.SOURCE_PATH, files.keySet().stream().map(Path::toFile).collect(Collectors.toList()));
        fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(buildDir.toFile()));
    }

    private static JavaCompiler.CompilationTask createCompilationTask(Multimap<Path, File> files, JavaCompiler compiler, StandardJavaFileManager fileManager) {
        Iterable<? extends JavaFileObject> objects = fileManager.getJavaFileObjectsFromFiles(files.values());
        return compiler.getTask(null, fileManager, diagnostic -> {
            switch (diagnostic.getKind()) {
                case ERROR: {
                    LOG.error(diagnostic.toString());
                    break;
                }
                case WARNING: {
                    LOG.warn(diagnostic.toString());
                    break;
                }
                case MANDATORY_WARNING: {
                    LOG.warn(diagnostic.toString());
                    break;
                }
                case NOTE: {
                    LOG.info(diagnostic.toString());
                    break;
                }
                case OTHER: {
                    LOG.info(diagnostic.toString());
                }
            }
        }, Lists.newArrayList("-g", "-Xlint:deprecation"), null, objects);
    }

    private static void copyResources(final @Nonnull Path buildDir, @Nonnull List<RootDefinition> resourceRoots) throws IOException {
        for (RootDefinition rd : resourceRoots) {
            final Path root = rd.getRoot();
            final List<PathMatcher> includes = rd.getIncludes();
            final List<PathMatcher> excludes = rd.getExcludes();
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path relativeFile = root.relativize(file);
                    if (includes.stream().noneMatch(m3 -> m3.matches(relativeFile)) || excludes.stream().anyMatch(m3 -> m3.matches(relativeFile))) {
                        return FileVisitResult.CONTINUE;
                    }
                    Path dirname = relativeFile.normalize().getParent();
                    if (dirname != null) {
                        Files.createDirectories(buildDir.resolve(dirname), new FileAttribute[0]);
                    }
                    Files.copy(file, buildDir.resolve(relativeFile), new CopyOption[0]);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    public static void compileSingleRoot(Path root, Path buildDir) throws IOException {
        FileSystem fs = FileSystems.getDefault();
        List<RootDefinition> sourceRoots = Collections.singletonList(new RootDefinition(root, Collections.singletonList(fs.getPathMatcher("glob:**.java")), Collections.emptyList()));
        List<RootDefinition> resourceRoots = Collections.singletonList(new RootDefinition(root, Collections.singletonList(fs.getPathMatcher("glob:**")), Collections.singletonList(fs.getPathMatcher("glob:**.java"))));
        Compiler.compile(buildDir, sourceRoots, resourceRoots);
    }
}

